/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import java.util.Date;
import net.jsdai.repo_edit.util.XmlExternalizableAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DateXmlExternalizer
implements XmlExternalizableAdapter {
    private static final String VERSION_ATTR = "version";
    private static final String TAG_NAME = "date";
    private static final String DATE_ATTRIBUTE = "date_value";
    private static final int VERSION_ID = 1;
    private final Date date;

    public static DateXmlExternalizer valueOf(Element elem) {
        return DateXmlExternalizer.valueOf(elem, null);
    }

    public static DateXmlExternalizer valueOf(Element elem, ClassLoader classLoader) {
        if (elem == null) {
            throw new NullPointerException();
        }
        if (!elem.getTagName().equals(TAG_NAME)) {
            throw new IllegalArgumentException();
        }
        String attribute = elem.getAttribute(DATE_ATTRIBUTE);
        return new DateXmlExternalizer(new Date(Long.parseLong(attribute)));
    }

    public DateXmlExternalizer(Date date) {
        if (date == null) {
            throw new NullPointerException();
        }
        this.date = date;
    }

    public Date getAdaptedObject() {
        return this.getDate();
    }

    public Date getDate() {
        return this.date;
    }

    public Element externalize(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        Element rootElem = doc.createElement(TAG_NAME);
        rootElem.setAttribute(VERSION_ATTR, String.valueOf(1));
        rootElem.setAttribute(DATE_ATTRIBUTE, String.valueOf(this.date.getTime()));
        return rootElem;
    }
}

