/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.InstallWizard3;
import org.eclipse.update.internal.ui.wizards.InstallWizardOperation;
import org.eclipse.update.ui.UpdateJob;

public class InstallWizardOperation2
extends InstallWizardOperation {
    private UpdateJob job;
    private IJobChangeListener jobListener;
    private Shell shell;
    private Shell parentShell;

    public void run(Shell parent, UpdateJob task) {
        this.shell = parent;
        if (this.shell.getParent() != null && this.shell.getParent() instanceof Shell) {
            this.parentShell = (Shell)this.shell.getParent();
        }
        if (this.jobListener != null) {
            Job.getJobManager().removeJobChangeListener(this.jobListener);
        }
        if (this.job != null) {
            Job.getJobManager().cancel((Object)this.job);
        }
        this.job = task;
        this.jobListener = new UpdateJobChangeListener();
        Job.getJobManager().addJobChangeListener(this.jobListener);
        this.job.schedule();
    }

    private Shell getValidShell() {
        if (this.shell.isDisposed()) {
            return this.parentShell;
        }
        return this.shell;
    }

    private class UpdateJobChangeListener
    extends JobChangeAdapter {
        private UpdateJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            final Shell validShell = InstallWizardOperation2.this.getValidShell();
            if (event.getJob() == InstallWizardOperation2.this.job) {
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                Job.getJobManager().cancel((Object)InstallWizardOperation2.this.job);
                if (InstallWizardOperation2.this.job.getStatus() == Status.CANCEL_STATUS) {
                    return;
                }
                if (InstallWizardOperation2.this.job.getStatus() != Status.OK_STATUS) {
                    InstallWizardOperation2.this.getValidShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            UpdateUI.log((IStatus)InstallWizardOperation2.this.job.getStatus(), (boolean)true);
                        }
                    });
                }
                validShell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        validShell.getDisplay().beep();
                        BusyIndicator.showWhile((Display)validShell.getDisplay(), (Runnable)new Runnable(){

                            public void run() {
                                UpdateJobChangeListener.this.openInstallWizard3();
                            }
                        });
                    }
                });
            }
        }

        private void openInstallWizard3() {
            if (InstallWizard3.isRunning()) {
                MessageDialog.openInformation((Shell)InstallWizardOperation2.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_isRunningTitle, (String)UpdateUIMessages.InstallWizard_isRunningInfo);
                return;
            }
            if (InstallWizardOperation2.this.job.getUpdates() == null || InstallWizardOperation2.this.job.getUpdates().length == 0) {
                if (InstallWizardOperation2.this.job.isUpdate()) {
                    MessageDialog.openInformation((Shell)InstallWizardOperation2.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroUpdates, (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroUpdates);
                } else {
                    MessageDialog.openInformation((Shell)InstallWizardOperation2.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroFeatures, (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroFeatures);
                }
                return;
            }
            InstallWizard3 wizard = new InstallWizard3(InstallWizardOperation2.this.job.getSearchRequest(), InstallWizardOperation2.this.job.getUpdates(), InstallWizardOperation2.this.job.isUpdate());
            wizard.addPages();
            if (!wizard.performFinish()) {
                wizard.performCancel();
            }
        }
    }
}

