/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractTextEllipsis {
    private static int DRAW_FLAGS = 12;
    private static final String ELLIPSIS = "...";
    private static final int INDENT = 2;
    private static final int ICON_GAP = 4;

    protected void drawCellForeground(GC gc, Rectangle rect, Image img, String text) {
        boolean shortenText;
        int imgWidth = 2;
        if (img != null) {
            gc.drawImage(img, rect.x + 2, rect.y);
            imgWidth += img.getBounds().width + 4;
        }
        int availableWidth = Math.max(0, rect.width - imgWidth);
        Point textSize = this.getTextSize(text, gc);
        boolean bl = shortenText = textSize.x > availableWidth;
        if (shortenText) {
            text = this.shortenText(gc, text, availableWidth);
        }
        gc.drawText(text, rect.x + imgWidth, rect.y + rect.height / 2 - textSize.y / 2, true);
    }

    private Point getTextSize(String text, GC gc) {
        Point size = new Point(0, 0);
        if (text != null && text.length() > 0) {
            Point e = gc.textExtent(text, DRAW_FLAGS);
            size.x = e.x;
            size.y = e.y;
        } else {
            size.y = Math.max(size.y, gc.getFontMetrics().getHeight());
        }
        return size;
    }

    protected String shortenText(GC gc, String t, int width) {
        if (t == null) {
            return null;
        }
        int w = gc.textExtent((String)ELLIPSIS, (int)AbstractTextEllipsis.DRAW_FLAGS).x;
        int toLeave = t.length();
        while (toLeave >= 0) {
            String s1 = t.substring(0, toLeave);
            int l1 = gc.textExtent((String)s1, (int)AbstractTextEllipsis.DRAW_FLAGS).x;
            if (l1 + w < width) {
                t = String.valueOf(s1) + ELLIPSIS;
                break;
            }
            --toLeave;
        }
        if (toLeave < 0) {
            t = ELLIPSIS;
        }
        return t;
    }
}

