/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.jsdai.l10n.CommonStringsMessages;
import net.jsdai.l10n.RepoEditBaseMessages;
import net.jsdai.repo_edit.jface.viewers.IFindCriterion;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class FindDialog
extends Dialog {
    public static final int FIND_NEXT_ID = 1001;
    public static final int FIND_PREVIOUS_ID = 1002;
    private Text input;
    private Button caseSensitiveButton;
    private Button wholeWordButton;
    private Button regexpButton;
    private Text errorMessageText;
    private FindDialogParam dlgParam;
    private Pattern selectedPattern;

    private FindDialog(Shell parentShell) {
        super(parentShell);
    }

    public FindDialog(Shell parentShell, FindDialogParam dlgParam) {
        this(parentShell);
        if (dlgParam == null) {
            dlgParam = new FindDialogParam(null, false, false, false);
        }
        this.dlgParam = dlgParam;
    }

    public IFindCriterion getFindCriterion() {
        if (this.dlgParam.isWholeWord()) {
            return this.selectedPattern == null ? null : new FindCriterionWholeWord(this.selectedPattern);
        }
        return this.selectedPattern == null ? null : new FindCriterion(this.selectedPattern);
    }

    public FindDialogParam getDialogParam() {
        return this.dlgParam;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CommonStringsMessages.find);
    }

    public void create() {
        super.create();
        this.validate();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Control inputPanel = this.createInputPanel(dialogArea);
        inputPanel.setLayoutData((Object)new GridData(4, 1, true, false));
        Control optionsPanel = this.createOptionsPanel(dialogArea);
        optionsPanel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.errorMessageText = new Text(dialogArea, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.errorMessageText.setBackground(dialogArea.getBackground());
        this.errorMessageText.setForeground(JFaceColors.getErrorText((Display)this.errorMessageText.getDisplay()));
        FindDialog.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1002, CommonStringsMessages.previous, false).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.findPressed(1002);
            }
        });
        this.createButton(parent, 1001, CommonStringsMessages.next, true).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.findPressed(1001);
            }
        });
    }

    private void findPressed(int buttonIndex) {
        this.setReturnCode(buttonIndex);
        try {
            this.selectedPattern = this.getPattern();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        this.close();
    }

    private Pattern getPattern() throws PatternSyntaxException {
        String text = this.input.getText();
        if (text.length() == 0) {
            return null;
        }
        int flags = this.caseSensitiveButton.getSelection() ? 0 : 2;
        if (!this.regexpButton.getSelection()) {
            flags |= 0x10;
        }
        return Pattern.compile(text, flags);
    }

    private void validate() {
        boolean enable;
        try {
            enable = this.getPattern() != null;
            this.errorMessageText.setText(" \n ");
        }
        catch (PatternSyntaxException e) {
            enable = false;
            this.errorMessageText.setText(e.getLocalizedMessage());
        }
        this.getButton(1001).setEnabled(enable);
        this.getButton(1002).setEnabled(enable);
    }

    private Control createOptionsPanel(Composite parent) {
        Composite optionsPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsPanel.setLayout((Layout)layout);
        this.caseSensitiveButton = new Button(optionsPanel, 16416);
        this.caseSensitiveButton.setText(RepoEditBaseMessages.FindDialog_caseSensitiveText);
        this.caseSensitiveButton.setSelection(this.dlgParam.isCaseSensitive());
        this.caseSensitiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.dlgParam.setCaseSensitive(FindDialog.this.caseSensitiveButton.getSelection());
            }
        });
        this.wholeWordButton = new Button(optionsPanel, 16416);
        this.wholeWordButton.setText(RepoEditBaseMessages.FindDialog_wholeWordText);
        this.wholeWordButton.setSelection(this.dlgParam.isWholeWord());
        this.wholeWordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.dlgParam.setWholeWord(FindDialog.this.wholeWordButton.getSelection());
            }
        });
        this.regexpButton = new Button(optionsPanel, 16416);
        this.regexpButton.setText(RepoEditBaseMessages.FindDialog_regexText);
        this.regexpButton.setSelection(this.dlgParam.isRegExp());
        this.regexpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.wholeWordButton.setEnabled(!FindDialog.this.regexpButton.getSelection());
                if (!FindDialog.this.wholeWordButton.getEnabled()) {
                    FindDialog.this.wholeWordButton.setSelection(false);
                }
                FindDialog.this.validate();
                FindDialog.this.dlgParam.setRegExp(FindDialog.this.regexpButton.getSelection());
            }
        });
        return optionsPanel;
    }

    private Control createInputPanel(Composite parent) {
        Composite inputPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inputPanel.setLayout((Layout)layout);
        Label label = new Label(inputPanel, 16384);
        label.setText(String.format("%s:", CommonStringsMessages.find));
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        this.input = new Text(inputPanel, 18432);
        this.input.setLayoutData((Object)new GridData(4, 2, true, false));
        if (this.dlgParam.getInput() != null) {
            this.input.setText(this.dlgParam.getInput());
            this.input.selectAll();
        }
        this.input.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindDialog.this.validate();
                FindDialog.this.dlgParam.setInput(FindDialog.this.input.getText());
            }
        });
        return inputPanel;
    }

    private static class FindCriterion
    implements IFindCriterion {
        private final Pattern pattern;

        public FindCriterion(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(String value) {
            if (value == null) {
                return false;
            }
            return this.pattern.matcher(value).find();
        }
    }

    private static class FindCriterionWholeWord
    implements IFindCriterion {
        private final Pattern pattern;

        public FindCriterionWholeWord(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(String value) {
            char endChar;
            char startChar;
            if (value == null) {
                return false;
            }
            Matcher matcher = this.pattern.matcher(value);
            if (!matcher.find()) {
                return false;
            }
            boolean start = true;
            boolean end = true;
            int matcherStart = matcher.start();
            int matcherEnd = matcher.end();
            if (matcherStart > 0 && Character.isJavaIdentifierPart(startChar = value.charAt(matcherStart - 1))) {
                start = false;
            }
            if (matcherEnd <= value.length() - 1 && Character.isJavaIdentifierPart(endChar = value.charAt(matcherEnd))) {
                end = false;
            }
            return start && end;
        }
    }

    static class FindDialogParam {
        private boolean caseSensitive;
        private boolean regExp;
        private boolean wholeWord;
        private String input;

        public FindDialogParam(String input, boolean caseSensitive, boolean regExp, boolean wholeWord) {
            this.input = input;
            this.caseSensitive = caseSensitive;
            this.regExp = regExp;
            this.wholeWord = wholeWord;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public boolean isRegExp() {
            return this.regExp;
        }

        public boolean isWholeWord() {
            return this.wholeWord;
        }

        public String getInput() {
            return this.input;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public void setRegExp(boolean regExp) {
            this.regExp = regExp;
        }

        public void setWholeWord(boolean wholeWord) {
            this.wholeWord = wholeWord;
        }

        public void setInput(String input) {
            this.input = input;
        }
    }
}

