/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.CellSelection;
import net.jsdai.repo_edit.jface.viewers.CellSelectionPainter;
import net.jsdai.repo_edit.jface.viewers.ICellSelection;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionManager;
import net.jsdai.repo_edit.jface.viewers.IRowSelection;
import net.jsdai.repo_edit.jface.viewers.RowSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

class SingleSelectionManager
implements ICellSelectionManager {
    private Control control;
    private Object selectedItemData = null;
    private int selectedColumn = -1;
    private Item focusedItem;
    private int focusedColumn;

    Object getSelectedItemData() {
        return this.selectedItemData;
    }

    SingleSelectionManager(Control control) {
        this.control = control;
    }

    int getSelectedColumn() {
        return this.selectedColumn;
    }

    IRowSelection getSelection() {
        RowSelection selection = new RowSelection();
        if (this.selectedItemData != null) {
            int[] nArray;
            if (this.selectedColumn >= 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.selectedColumn;
            } else {
                nArray = new int[]{};
            }
            int[] columns = nArray;
            CellSelection row = new CellSelection(this.selectedItemData, columns);
            selection.addRow(row);
        }
        return selection;
    }

    void setSelection(IRowSelection selection) {
        ICellSelection first = selection.getFirst();
        if (first == null) {
            this.selectedItemData = null;
            this.selectedColumn = -1;
        } else {
            this.selectedItemData = first.getData();
            int[] columns = first.getColumns();
            if (columns.length > 0) {
                this.selectedColumn = columns[0];
            }
        }
    }

    void setSelection(Object data, int column) {
        this.selectedItemData = data;
        this.selectedColumn = column;
    }

    void clearSelection() {
        this.selectedItemData = null;
        this.selectedColumn = -1;
    }

    boolean isEmpty() {
        return this.selectedItemData == null;
    }

    boolean sameSelection(Object data, int column) {
        if (data == null && this.selectedItemData == null) {
            return true;
        }
        if (this.selectedItemData == null) {
            return false;
        }
        return this.selectedItemData.equals(data) && this.selectedColumn == column;
    }

    private boolean isSelected(Item item, int column) {
        return this.control.isFocusControl() && this.isSelected(item) && column >= 0 && this.selectedColumn == column;
    }

    public boolean isSelected(Item item) {
        return item != null && this.selectedItemData != null && this.selectedItemData.equals(item.getData());
    }

    public CellSelectionPainter.Style getCellStyle(Item item, int column) {
        if (item != null && this.selectedItemData != null && this.selectedItemData.equals(item.getData())) {
            if (column >= 0 && this.selectedColumn == column) {
                if (this.control.isFocusControl()) {
                    return CellSelectionPainter.Style.SELECTED;
                }
                return CellSelectionPainter.Style.UNFOCUSED_SELECTION;
            }
            return CellSelectionPainter.Style.INCATIVE;
        }
        return CellSelectionPainter.Style.NORMAL;
    }

    void setFocusedCell(Item focusedItem, int focusedColumn) {
        this.focusedItem = focusedItem;
        this.focusedColumn = focusedColumn;
    }

    public boolean isFocused(Item item, int column) {
        if (item != null && this.focusedItem != null && !this.focusedItem.isDisposed()) {
            return this.focusedItem == item && column == this.focusedColumn;
        }
        return this.control.isFocusControl() && this.isSelected(item, column);
    }
}

