/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.Cell;
import net.jsdai.repo_edit.jface.viewers.CellDropAdapter;
import net.jsdai.repo_edit.jface.viewers.IFocusFeedbackProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableCellDropAdapter
extends CellDropAdapter {
    public TableCellDropAdapter(Table control, IFocusFeedbackProvider cellFocusFeedback) {
        super((Control)control, cellFocusFeedback);
    }

    private Table getControl() {
        return (Table)this.control;
    }

    protected Cell determineDropTarget(DropTargetEvent event) {
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        return TableCellDropAdapter.findCell(this.getControl().getItems(), coordinates);
    }

    protected void showColumn(int index) {
        this.getControl().showColumn(this.getControl().getColumn(index));
    }

    protected int getColumncount() {
        return this.getControl().getColumnCount();
    }

    protected int[] getColumnOrder() {
        return this.getControl().getColumnOrder();
    }

    public static Cell findCell(TableItem[] items, Point point) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            int index = TableCellDropAdapter.findColumnIndex(item, point);
            if (index != -1) {
                return new Cell((Item)item, index);
            }
            ++n2;
        }
        return null;
    }

    public static int findColumnIndex(TableItem item, Point point) {
        int i = 0;
        while (i < item.getParent().getColumnCount()) {
            if (TableCellDropAdapter.contains(item.getBounds(i), point)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

