/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.AbstractSelectionProvider;
import net.jsdai.repo_edit.jface.viewers.CustomDrawingFactory;
import net.jsdai.repo_edit.jface.viewers.ICellSelection;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionFilter;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionProvider;
import net.jsdai.repo_edit.jface.viewers.IFocusFeedbackProvider;
import net.jsdai.repo_edit.jface.viewers.IRowSelection;
import net.jsdai.repo_edit.jface.viewers.SelectionFilters;
import net.jsdai.repo_edit.jface.viewers.SingleSelectionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableSelectionProvider
extends AbstractSelectionProvider
implements ICellSelectionProvider,
IFocusFeedbackProvider,
Listener {
    private TableViewer viewer;
    private Table control;
    private SelectionFilters filters;
    private SingleSelectionManager manager;
    private Listener paintListener;
    private Listener scrollListener;
    private ISelectionChangedListener invalidSelectionListener;

    public TableSelectionProvider(TableViewer viewer) {
        this(viewer, CustomDrawingFactory.getInstance().getTableForegroundPainter());
    }

    public TableSelectionProvider(TableViewer viewer, Listener foregroundPainter) {
        Table table = viewer.getTable();
        if (table == null || foregroundPainter == null) {
            throw new IllegalArgumentException();
        }
        if ((table.getStyle() & 4) == 0 || (table.getStyle() & 2) != 0) {
            throw new IllegalArgumentException("Control style should have set SWT.SINGLE and not SWT.MULTI");
        }
        this.viewer = viewer;
        this.control = table;
        this.manager = new SingleSelectionManager((Control)this.control);
        this.filters = new SelectionFilters();
        CustomDrawingFactory factory = CustomDrawingFactory.getInstance();
        this.paintListener = factory.getTableSelectionPainter(this.manager, foregroundPainter);
        this.control.addListener(3, (Listener)this);
        this.control.addListener(13, (Listener)this);
        this.control.addListener(1, (Listener)this);
        this.control.addListener(31, (Listener)this);
        this.control.addListener(15, (Listener)this);
        this.control.addListener(16, (Listener)this);
        this.control.addListener(40, this.paintListener);
        this.control.addListener(42, this.paintListener);
        this.scrollListener = new Listener(){

            public void handleEvent(Event e) {
                TableSelectionProvider.this.control.redraw();
            }
        };
        this.control.getHorizontalBar().addListener(13, this.scrollListener);
        this.control.getVerticalBar().addListener(13, this.scrollListener);
        this.invalidSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    TableSelectionProvider.this.handleInvalidSelection();
                }
            }
        };
        viewer.addSelectionChangedListener(this.invalidSelectionListener);
        this.control.redraw();
    }

    public void dispose() {
        this.control.removeListener(13, (Listener)this);
        this.control.removeListener(1, (Listener)this);
        this.control.removeListener(3, (Listener)this);
        this.control.removeListener(31, (Listener)this);
        this.control.removeListener(15, (Listener)this);
        this.control.removeListener(16, (Listener)this);
        this.control.removeListener(40, this.paintListener);
        this.control.removeListener(42, this.paintListener);
        this.control.getHorizontalBar().removeListener(13, this.scrollListener);
        this.control.getVerticalBar().removeListener(13, this.scrollListener);
        this.viewer.removeSelectionChangedListener(this.invalidSelectionListener);
    }

    public void addFilter(ICellSelectionFilter filter) {
        this.filters.addfilter(filter);
    }

    public void removeFilter(ICellSelectionFilter filter) {
        this.filters.removefilter(filter);
    }

    public ISelection getSelection() {
        return this.manager.getSelection();
    }

    public IRowSelection getRowSelection() {
        return this.manager.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (selection.isEmpty()) {
            this.clearSelection();
        } else if (selection instanceof IRowSelection) {
            IRowSelection rowSelection = (IRowSelection)selection;
            ICellSelection first = rowSelection.getFirst();
            if (first != null && !first.isEmpty()) {
                Object data = first.getData();
                TableItem item = this.findItem(this.control.getItems(), data);
                this.setSelectionInternal(item, data, first.getColumns()[0], false);
            } else {
                this.clearSelection();
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setFocusTo(Item item, int column) {
        this.manager.setFocusedCell(item, column);
        this.control.redraw();
    }

    public void unsetFocus() {
        this.manager.setFocusedCell(null, -1);
        this.control.redraw();
    }

    public void handleEvent(Event e) {
        if (!e.doit) {
            return;
        }
        if (e.type == 13) {
            TableItem[] selection = this.control.getSelection();
            if (selection.length > 0) {
                TableItem item = selection[0];
                int column = this.getSelectedColumn();
                if (column < 0) {
                    column = 0;
                }
                this.setSelectionInternal(item, column, true);
            } else {
                this.clearSelection();
            }
        } else if (e.type == 1) {
            if (e.keyCode == 0x1000003) {
                int[] order = this.control.getColumnOrder();
                TableItem item = this.getSelectedItem();
                int column = this.getSelectedColumnOrder(order) - 1;
                if (item == null && this.control.getItemCount() > 0) {
                    item = this.control.getItem(0);
                    column = order[this.control.getColumnCount() - 1];
                }
                if (item != null && column >= 0 && this.filters.canSelect(item.getData(), order[column])) {
                    this.setSelectionInternal(item, order[column], true);
                }
                e.doit = false;
            } else if (e.keyCode == 0x1000004) {
                int[] order = this.control.getColumnOrder();
                TableItem item = this.getSelectedItem();
                int column = this.getSelectedColumnOrder(order) + 1;
                if (item == null && this.control.getItemCount() > 0) {
                    item = this.control.getItem(0);
                    column = 0;
                }
                if (item != null && column < this.control.getColumnCount() && this.filters.canSelect(item.getData(), order[column])) {
                    this.setSelectionInternal(item, order[column], true);
                }
                e.doit = false;
            } else if (e.character == '\r') {
                int[] order = this.control.getColumnOrder();
                Object item = this.getSelectedItem();
                int column = this.getSelectedColumn();
                if (this.control.getItemCount() > 0) {
                    if (item == null) {
                        TableItem firstItem = this.control.getItem(0);
                        this.setSelectionInternal(firstItem, order[0], true);
                        e.doit = false;
                    } else {
                        int indexOf = this.control.indexOf(item);
                        do {
                            if (e.stateMask == 0) {
                                ++indexOf;
                                continue;
                            }
                            if (e.stateMask != 131072) break;
                            --indexOf;
                        } while ((item = indexOf >= 0 && indexOf < this.control.getItemCount() ? this.control.getItem(indexOf) : null) != null && !this.filters.canSelect(item.getData(), column));
                        if (item != null) {
                            this.setSelectionInternal((TableItem)item, column, true);
                            e.doit = false;
                        }
                    }
                }
            } else if (e.keyCode == 0x100000B) {
                TableItem item = this.getSelectedItem();
                int column = this.getSelectedColumn();
                if (item != null && column >= 0) {
                    this.viewer.editElement(item.getData(), column);
                    e.doit = false;
                }
            } else if (this.isPrintable(e.character) && (e.stateMask == 0 || e.stateMask == 131072)) {
                TableItem item = this.getSelectedItem();
                int column = this.getSelectedColumn();
                if (item != null && column >= 0) {
                    e.doit = false;
                    this.viewer.editElement(item.getData(), column);
                    if (this.viewer.isCellEditorActive()) {
                        item.getDisplay().post(e);
                    }
                }
            }
        } else if (e.type == 31 && (e.detail == 16 || e.detail == 8)) {
            int[] order = this.control.getColumnOrder();
            Object item = this.getSelectedItem();
            int column = this.getSelectedColumnOrder(order);
            if (this.control.getItemCount() > 0) {
                if (item == null) {
                    this.control.showColumn(this.control.getColumn(this.getColumnOrder(order, 0)));
                    TableItem firstItem = this.control.getItem(0);
                    this.setSelectionInternal(firstItem, 0, true);
                    e.doit = false;
                } else {
                    int indexOf = this.control.indexOf(item);
                    do {
                        if (e.detail == 16) {
                            ++column;
                        } else {
                            if (e.detail != 8) break;
                            --column;
                        }
                        if (column < 0) {
                            column = this.control.getColumnCount() - 1;
                            --indexOf;
                        }
                        if (column < this.control.getColumnCount()) continue;
                        column = 0;
                        ++indexOf;
                    } while ((item = indexOf >= 0 && indexOf < this.control.getItemCount() ? this.control.getItem(indexOf) : null) != null && !this.filters.canSelect(item.getData(), order[column]));
                    if (item != null) {
                        this.setSelectionInternal((TableItem)item, order[column], true);
                        e.doit = false;
                    }
                }
            }
        } else if (e.type == 15 || e.type == 16) {
            this.control.redraw();
        } else if (e.type == 3 && !this.select(this.control.getItems(), e.x, e.y) && !this.manager.isEmpty()) {
            this.clearSelection();
        }
    }

    private TableItem getSelectedItem() {
        TableItem item = this.findItem(this.control.getItems(), this.manager.getSelectedItemData());
        return item;
    }

    private int getSelectedColumnOrder(int[] columnOrder) {
        int column = this.getSelectedColumn();
        if (column < 0) {
            return column;
        }
        return this.getColumnOrder(columnOrder, column);
    }

    private int getColumnOrder(int[] columnOrder, int column) {
        int i = 0;
        while (i < columnOrder.length) {
            if (columnOrder[i] == column) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("Can not find order of column: " + column);
    }

    private int getSelectedColumn() {
        return this.manager.getSelectedColumn();
    }

    private void handleInvalidSelection() {
        Object itemData = this.manager.getSelectedItemData();
        if (itemData != null) {
            TableItem newItem = this.findItem(this.control.getItems(), itemData);
            this.setSelectionInternal(newItem, 0, false);
        }
    }

    private void setSelectionInternal(TableItem item, int column, boolean delayPostEvent) {
        Object newSelectedItemData = item == null ? null : item.getData();
        this.setSelectionInternal(item, newSelectedItemData, column, delayPostEvent);
    }

    private void setSelectionInternal(TableItem item, Object data, int column, boolean delayPostEvent) {
        if (column < 0) {
            throw new IllegalArgumentException();
        }
        TableItem oldItem = this.getSelectedItem();
        if (!this.manager.sameSelection(data, column)) {
            if (column < this.control.getColumnCount()) {
                this.control.showColumn(this.control.getColumn(column));
            }
            this.manager.setSelection(data, column);
            if (oldItem != item) {
                if (item == null) {
                    this.control.deselectAll();
                } else {
                    this.control.setSelection(item);
                }
            }
            this.control.redraw();
            this.notifyListeners();
            if (delayPostEvent) {
                this.control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TableSelectionProvider.this.notifyPostSelectionListeners();
                    }
                });
            } else {
                this.notifyPostSelectionListeners();
            }
        }
    }

    private void clearSelection() {
        this.setSelectionInternal(null, this.manager.getSelectedColumn(), false);
    }

    private TableItem findItem(TableItem[] items, Object data) {
        if (items != null) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() != null && item.getData().equals(data)) {
                    return item;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean select(TableItem[] items, int x, int y) {
        if (items != null) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                int column = 0;
                while (column < this.control.getColumnCount()) {
                    if (item.getBounds(column).contains(x, y)) {
                        if (this.filters.canSelect(data, column)) {
                            this.setSelectionInternal(item, column, false);
                        }
                        return true;
                    }
                    ++column;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isPrintable(char character) {
        return character != '\u0000' && character != '\b' && character != '\r' && character != '\u007f' && character != '\u001b' && character != '\n' && character != '\t';
    }

    public Table getControl() {
        return this.control;
    }
}

