/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.Cell;
import net.jsdai.repo_edit.jface.viewers.CellDropAdapter;
import net.jsdai.repo_edit.jface.viewers.IFocusFeedbackProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeCellDropAdapter
extends CellDropAdapter {
    public TreeCellDropAdapter(Tree control, IFocusFeedbackProvider cellFocusFeedback) {
        super((Control)control, cellFocusFeedback);
    }

    private Tree getControl() {
        return (Tree)this.control;
    }

    protected Cell determineDropTarget(DropTargetEvent event) {
        Point coordinates = new Point(event.x, event.y);
        coordinates = this.control.toControl(coordinates);
        return TreeCellDropAdapter.findCell(this.getControl().getItems(), coordinates);
    }

    protected void showColumn(int index) {
        this.getControl().showColumn(this.getControl().getColumn(index));
    }

    protected int getColumncount() {
        return this.getControl().getColumnCount();
    }

    protected int[] getColumnOrder() {
        return this.getControl().getColumnOrder();
    }

    private static Cell findCell(TreeItem[] items, Point point) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            int index = TreeCellDropAdapter.findColumnIndex(item, point);
            if (index != -1) {
                return new Cell((Item)item, index);
            }
            Cell treeCell = TreeCellDropAdapter.findCell(item.getItems(), point);
            if (treeCell != null) {
                return treeCell;
            }
            ++n2;
        }
        return null;
    }

    private static int findColumnIndex(TreeItem item, Point point) {
        int i = 0;
        while (i < item.getParent().getColumnCount()) {
            if (TreeCellDropAdapter.contains(item.getBounds(i), point)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

