/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.AbstractSelectionProvider;
import net.jsdai.repo_edit.jface.viewers.CustomDrawingFactory;
import net.jsdai.repo_edit.jface.viewers.ICellSelection;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionFilter;
import net.jsdai.repo_edit.jface.viewers.ICellSelectionProvider;
import net.jsdai.repo_edit.jface.viewers.IFocusFeedbackProvider;
import net.jsdai.repo_edit.jface.viewers.IRowSelection;
import net.jsdai.repo_edit.jface.viewers.SelectionFilters;
import net.jsdai.repo_edit.jface.viewers.SingleSelectionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeSelectionProvider
extends AbstractSelectionProvider
implements ICellSelectionProvider,
IFocusFeedbackProvider,
Listener {
    private TreeViewer viewer;
    private Tree control;
    private SelectionFilters filters;
    private SingleSelectionManager manager;
    private Listener paintListener;
    private Listener scrollListener;
    private ISelectionChangedListener invalidSelectionListener;

    public TreeSelectionProvider(TreeViewer viewer) {
        this(viewer, CustomDrawingFactory.getInstance().getTreeForegroundPainter());
    }

    public TreeSelectionProvider(TreeViewer viewer, Listener foregroundPainter) {
        Tree tree = viewer.getTree();
        if (tree == null || foregroundPainter == null) {
            throw new IllegalArgumentException();
        }
        if ((tree.getStyle() & 4) == 0 || (tree.getStyle() & 2) != 0) {
            throw new IllegalArgumentException("Control style should have set SWT.SINGLE and not SWT.MULTI");
        }
        this.viewer = viewer;
        this.control = tree;
        this.manager = new SingleSelectionManager((Control)this.control);
        this.filters = new SelectionFilters();
        this.paintListener = CustomDrawingFactory.getInstance().getTreeSelectionPainter(this.manager, foregroundPainter);
        this.control.addListener(13, (Listener)this);
        this.control.addListener(1, (Listener)this);
        this.control.addListener(3, (Listener)this);
        this.control.addListener(31, (Listener)this);
        this.control.addListener(15, (Listener)this);
        this.control.addListener(16, (Listener)this);
        this.control.getColumn(0).addListener(11, (Listener)this);
        this.control.addListener(40, this.paintListener);
        this.control.addListener(42, this.paintListener);
        this.scrollListener = new Listener(){

            public void handleEvent(Event e) {
                TreeSelectionProvider.this.control.redraw();
            }
        };
        this.control.getHorizontalBar().addListener(13, this.scrollListener);
        this.control.getVerticalBar().addListener(13, this.scrollListener);
        this.invalidSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    TreeSelectionProvider.this.handleInvalidSelection();
                }
            }
        };
        viewer.addSelectionChangedListener(this.invalidSelectionListener);
        this.control.redraw();
    }

    public void dispose() {
        this.control.removeListener(13, (Listener)this);
        this.control.removeListener(1, (Listener)this);
        this.control.removeListener(3, (Listener)this);
        this.control.removeListener(31, (Listener)this);
        this.control.removeListener(15, (Listener)this);
        this.control.removeListener(16, (Listener)this);
        this.control.getColumn(0).removeListener(11, (Listener)this);
        this.control.removeListener(40, this.paintListener);
        this.control.removeListener(42, this.paintListener);
        this.control.getHorizontalBar().removeListener(13, this.scrollListener);
        this.control.getVerticalBar().removeListener(13, this.scrollListener);
        this.viewer.removeSelectionChangedListener(this.invalidSelectionListener);
    }

    public void addFilter(ICellSelectionFilter filter) {
        this.filters.addfilter(filter);
    }

    public void removeFilter(ICellSelectionFilter filter) {
        this.filters.removefilter(filter);
    }

    public ISelection getSelection() {
        return this.manager.getSelection();
    }

    public IRowSelection getRowSelection() {
        return this.manager.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (selection.isEmpty()) {
            this.clearSelection();
        } else if (selection instanceof IRowSelection) {
            IRowSelection rowSelection = (IRowSelection)selection;
            ICellSelection first = rowSelection.getFirst();
            if (first != null && !first.isEmpty()) {
                Object data = first.getData();
                TreeItem item = TreeSelectionProvider.findItem(this.control.getItems(), data);
                this.setSelectionInternal(item, data, first.getColumns()[0], false);
            } else {
                this.clearSelection();
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setFocusTo(Item item, int column) {
        this.manager.setFocusedCell(item, column);
        this.control.redraw();
    }

    public void unsetFocus() {
        this.manager.setFocusedCell(null, -1);
        this.control.redraw();
    }

    public void handleEvent(Event e) {
        if (!e.doit) {
            return;
        }
        if (e.type == 13 || e.type == 14) {
            TreeItem[] selection = this.control.getSelection();
            if (selection.length > 0) {
                TreeItem item = selection[0];
                int column = this.getSelectedColumn();
                if (column < 0) {
                    column = 0;
                }
                this.setSelectionInternal(item, column, true);
            } else {
                this.clearSelection();
            }
        } else if (e.type == 1) {
            if (e.keyCode == 0x1000003) {
                int[] order = this.control.getColumnOrder();
                TreeItem item = this.getSelectedItem();
                int column = this.getSelectedColumnOrder(order) - 1;
                if (item == null && this.control.getItemCount() > 0) {
                    item = this.control.getItem(0);
                    column = order[this.control.getColumnCount() - 1];
                }
                if (item != null && column >= 0 && this.filters.canSelect(item.getData(), order[column])) {
                    this.setSelectionInternal(item, order[column], true);
                }
                e.doit = false;
            } else if (e.keyCode == 0x1000004) {
                int[] order = this.control.getColumnOrder();
                TreeItem item = this.getSelectedItem();
                int column = this.getSelectedColumnOrder(order) + 1;
                if (item == null && this.control.getItemCount() > 0) {
                    item = this.control.getItem(0);
                    column = 0;
                }
                if (item != null && column < this.control.getColumnCount() && this.filters.canSelect(item.getData(), order[column])) {
                    this.setSelectionInternal(item, order[column], true);
                }
                e.doit = false;
            } else if (e.character == '\r') {
                int[] order = this.control.getColumnOrder();
                TreeItem item = this.getSelectedItem();
                int column = this.getSelectedColumn();
                if (this.control.getItemCount() > 0) {
                    if (item == null) {
                        TreeItem firstItem = this.control.getItem(0);
                        this.setSelectionInternal(firstItem, order[0], true);
                        e.doit = false;
                    } else if (e.stateMask == 262144 && column == 0) {
                        boolean expanded = item.getExpanded();
                        int eventType = expanded ? 18 : 17;
                        Event event = new Event();
                        event.item = item;
                        this.control.notifyListeners(eventType, event);
                        item.setExpanded(!expanded);
                        e.doit = false;
                    } else if (e.stateMask == 0) {
                        if (column < 0) {
                            column = 0;
                        }
                        while ((item = this.findNext(item)) != null && !this.filters.canSelect(item.getData(), column)) {
                        }
                        if (item != null) {
                            this.setSelectionInternal(item, column, true);
                            e.doit = false;
                        }
                    } else if (e.stateMask == 131072) {
                        if (column < 0) {
                            column = 0;
                        }
                        while ((item = this.findPrevious(item)) != null && !this.filters.canSelect(item.getData(), column)) {
                        }
                        if (item != null) {
                            this.setSelectionInternal(item, column, true);
                            e.doit = false;
                        }
                    }
                }
            } else if (e.keyCode == 0x100000B) {
                TreeItem item = this.getSelectedItem();
                int column = this.getSelectedColumn();
                if (item != null && column >= 0) {
                    this.viewer.editElement(item.getData(), column);
                }
            } else if (this.isPrintable(e.character) && (e.stateMask == 0 || e.stateMask == 131072)) {
                TreeItem item = this.getSelectedItem();
                int column = this.getSelectedColumn();
                if (item != null && column >= 0) {
                    e.doit = false;
                    this.viewer.editElement(item.getData(), column);
                    if (this.viewer.isCellEditorActive()) {
                        item.getDisplay().post(e);
                    }
                }
            } else if (e.character == '\t') {
                e.doit = false;
            }
        } else if (e.type == 3) {
            if (!this.select(this.control.getItems(), e.x, e.y) && !this.manager.isEmpty()) {
                this.clearSelection();
            }
        } else if (e.type == 31 && (e.detail == 16 || e.detail == 8)) {
            int[] order = this.control.getColumnOrder();
            TreeItem newItem = null;
            int newColumn = -1;
            TreeItem item = this.getSelectedItem();
            int column = this.getSelectedColumnOrder(order);
            if (this.control.getItemCount() > 0) {
                if (item == null) {
                    this.control.showColumn(this.control.getColumn(this.getColumnOrder(order, 0)));
                    TreeItem firstItem = this.control.getItem(0);
                    this.setSelectionInternal(firstItem, 0, true);
                    e.doit = false;
                } else {
                    newItem = item;
                    newColumn = column;
                    do {
                        if (e.detail == 16) {
                            ++newColumn;
                        } else {
                            if (e.detail != 8) break;
                            --newColumn;
                        }
                        if (newColumn < 0) {
                            newColumn = this.control.getColumnCount() - 1;
                            newItem = this.findPrevious(item);
                        }
                        if (newColumn < this.control.getColumnCount()) continue;
                        newColumn = 0;
                        newItem = this.findNext(item);
                    } while (newItem != null && !this.filters.canSelect(newItem.getData(), order[newColumn]));
                    this.setSelectionInternal(newItem, order[newColumn], true);
                    e.doit = false;
                }
            }
        } else if (e.type == 15 || e.type == 16) {
            this.control.redraw();
        } else if (e.type == 11) {
            this.control.redraw();
        }
    }

    private void handleInvalidSelection() {
        Object itemData = this.manager.getSelectedItemData();
        if (itemData != null) {
            TreeItem newItem = TreeSelectionProvider.findItem(this.control.getItems(), itemData);
            this.setSelectionInternal(newItem, this.manager.getSelectedColumn(), false);
        }
    }

    private TreeItem getSelectedItem() {
        TreeItem item = TreeSelectionProvider.findItem(this.control.getItems(), this.manager.getSelectedItemData());
        return item;
    }

    private void setSelectionInternal(TreeItem item, int column, boolean delayPostEvent) {
        Object newSelectedItemData = item == null ? null : item.getData();
        this.setSelectionInternal(item, newSelectedItemData, column, delayPostEvent);
    }

    private void setSelectionInternal(TreeItem item, Object data, int column, boolean delayPostEvent) {
        TreeItem oldItem = this.getSelectedItem();
        if (!this.manager.sameSelection(data, column)) {
            this.control.showColumn(this.control.getColumn(column));
            this.manager.setSelection(data, column);
            if (oldItem != item) {
                if (item == null) {
                    this.control.deselectAll();
                } else {
                    this.control.setSelection(item);
                }
            }
            this.control.redraw();
            this.notifyListeners();
            if (delayPostEvent) {
                this.control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TreeSelectionProvider.this.notifyPostSelectionListeners();
                    }
                });
            } else {
                this.notifyPostSelectionListeners();
            }
        }
    }

    private void clearSelection() {
        this.setSelectionInternal(null, this.manager.getSelectedColumn(), false);
    }

    private int getSelectedColumn() {
        return this.manager.getSelectedColumn();
    }

    private int getSelectedColumnOrder(int[] columnOrder) {
        int column = this.getSelectedColumn();
        if (column < 0) {
            return column;
        }
        return this.getColumnOrder(columnOrder, column);
    }

    private int getColumnOrder(int[] columnOrder, int column) {
        int i = 0;
        while (i < columnOrder.length) {
            if (columnOrder[i] == column) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("Can not find order of column: " + column);
    }

    private boolean select(TreeItem[] items, int x, int y) {
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object data = item.getData();
                int column = 0;
                while (column < this.control.getColumnCount()) {
                    if (item.getBounds(column).contains(x, y)) {
                        if (this.filters.canSelect(data, column)) {
                            this.setSelectionInternal(item, column, false);
                        }
                        return true;
                    }
                    ++column;
                }
                if (item.getItems().length > 0 && this.select(item.getItems(), x, y)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static TreeItem findItem(TreeItem[] items, Object data) {
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (!item.isDisposed()) {
                    if (item.getData() != null && item.getData().equals(data)) {
                        return item;
                    }
                    TreeItem foundChild = TreeSelectionProvider.findItem(item.getItems(), data);
                    if (foundChild != null) {
                        return foundChild;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private TreeItem findPrevious(TreeItem item) {
        TreeItem parent = item.getParentItem();
        TreeItem[] items = parent == null ? this.control.getItems() : parent.getItems();
        TreeItem previous = this.findPrevious(items, item);
        previous = previous == null ? parent : this.findLastExpandedChild(previous);
        return previous;
    }

    private TreeItem findNext(TreeItem item) {
        if (item.getExpanded() && item.getItemCount() > 0) {
            return item.getItem(0);
        }
        TreeItem parent = item.getParentItem();
        TreeItem[] items = parent == null ? this.control.getItems() : parent.getItems();
        TreeItem next = this.findNext(items, item);
        if (next == null && parent != null) {
            next = this.findNextParent(parent);
        }
        return next;
    }

    private TreeItem findLastExpandedChild(TreeItem item) {
        if (item.getExpanded() && item.getItemCount() > 0) {
            int last = item.getItemCount() - 1;
            TreeItem lastItem = item.getItem(last);
            item = this.findLastExpandedChild(lastItem);
        }
        return item;
    }

    private TreeItem findNextParent(TreeItem parent) {
        TreeItem grandp = parent.getParentItem();
        if (grandp == null) {
            return this.findNext(this.control.getItems(), parent);
        }
        TreeItem nextParent = this.findNext(grandp.getItems(), parent);
        if (nextParent == null) {
            return this.findNextParent(grandp);
        }
        return nextParent;
    }

    private TreeItem findPrevious(TreeItem[] items, TreeItem item) {
        int i = 0;
        while (i < items.length - 1) {
            if (items[i + 1] == item) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private TreeItem findNext(TreeItem[] items, TreeItem item) {
        int i = 0;
        while (i < items.length - 1) {
            if (items[i] == item) {
                return items[i + 1];
            }
            ++i;
        }
        return null;
    }

    private boolean isPrintable(char character) {
        return character != '\u0000' && character != '\b' && character != '\r' && character != '\u007f' && character != '\u001b' && character != '\n' && character != '\t';
    }
}

