/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.jface.viewers;

import net.jsdai.repo_edit.jface.viewers.ColumnViewerSorter;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeSorter
extends ColumnViewerSorter {
    public TreeSorter(TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        Tree tree = treeViewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        int n = columns.length;
        int i = 0;
        while (i < n) {
            this.addSortListener(treeViewer, i, columns[i]);
            ++i;
        }
    }

    public TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }

    public void addColumn(int columnIndex) {
        TreeColumn treeColumn = this.getViewer().getTree().getColumn(columnIndex);
        this.addSortListener(this.getViewer(), columnIndex, treeColumn);
    }

    private void addSortListener(final TreeViewer treeViewer, final int index, final TreeColumn column) {
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] expandedElems = TreeSorter.this.getViewer().getExpandedElements();
                TreeSorter.this.setSorterColumn(index);
                if (expandedElems != null) {
                    TreeSorter.this.getViewer().setExpandedElements(expandedElems);
                }
                treeViewer.getTree().setSortDirection(TreeSorter.this.getSortDirection());
                treeViewer.getTree().setSortColumn(column);
            }
        });
    }
}

