/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.part;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleFieldEditor
extends StringFieldEditor {
    private static final int DEFAULT_TEXT_LIMIT = 30;
    public static final Validator POSITIVE = new Validator(){

        public boolean isValid(double value) {
            return value > 0.0;
        }

        public String getErrorMessage() {
            return "Value must be greater than zero.";
        }
    };
    public static final Validator ZERO_OR_POSITIVE = new Validator(){

        public boolean isValid(double value) {
            return value >= 0.0;
        }

        public String getErrorMessage() {
            return "Value must not be negative.";
        }
    };
    private Validator valueValidator;

    public DoubleFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 30);
    }

    public DoubleFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.createControl(parent);
    }

    public void setValidator(Validator validator) {
        this.valueValidator = validator;
        this.refreshValidState();
    }

    public double getDoubleValue() {
        try {
            return this.getDoubleValueInner();
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private double getDoubleValueInner() throws NumberFormatException {
        return Double.valueOf(this.getStringValue());
    }

    protected boolean doCheckState() {
        Text text = this.getTextControl();
        if (text == null) {
            return false;
        }
        String errorMessage = null;
        try {
            double number = this.getDoubleValueInner();
            if (this.valueValidator != null && !this.valueValidator.isValid(number)) {
                errorMessage = this.valueValidator.getErrorMessage();
            }
        }
        catch (NumberFormatException e) {
            errorMessage = "Value must be a real number.";
        }
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
            text.setText(String.valueOf(value));
            this.oldValue = text.getText();
        }
        this.valueChanged();
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
            text.setText(String.valueOf(value));
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getDoubleValueInner());
    }

    public static interface Validator {
        public boolean isValid(double var1);

        public String getErrorMessage();
    }
}

