/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import java.util.Comparator;

public class AlphanumComparator
implements Comparator {
    static char[] numbers = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};

    private static boolean isIn(char ch, char[] chars) {
        int i = 0;
        while (i < chars.length) {
            if (ch == chars[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean inChunk(char ch, String s) {
        if (s.length() == 0) {
            return true;
        }
        char s0 = s.charAt(0);
        boolean chunkType = false;
        if (AlphanumComparator.isIn(s0, numbers)) {
            chunkType = true;
        }
        if (!chunkType && AlphanumComparator.isIn(ch, numbers)) {
            return false;
        }
        return !chunkType || AlphanumComparator.isIn(ch, numbers);
    }

    public int compare(Object o1, Object o2) {
        String s1 = String.valueOf(o1);
        String s2 = String.valueOf(o2);
        return AlphanumComparator.compareStrings(s1, s2);
    }

    public static int compareStrings(String s1, String s2) throws NumberFormatException {
        int thisMarker = 0;
        long thisNumericChunk = 0L;
        String thisChunk = new String();
        int thatMarker = 0;
        long thatNumericChunk = 0L;
        String thatChunk = new String();
        while (thisMarker < s1.length() && thatMarker < s2.length()) {
            char thisCh = s1.charAt(thisMarker);
            char thatCh = s2.charAt(thatMarker);
            thisChunk = "";
            thatChunk = "";
            while (thisMarker < s1.length() && AlphanumComparator.inChunk(thisCh, thisChunk)) {
                thisChunk = String.valueOf(thisChunk) + thisCh;
                if (++thisMarker >= s1.length()) continue;
                thisCh = s1.charAt(thisMarker);
            }
            while (thatMarker < s2.length() && AlphanumComparator.inChunk(thatCh, thatChunk)) {
                thatChunk = String.valueOf(thatChunk) + thatCh;
                if (++thatMarker >= s2.length()) continue;
                thatCh = s2.charAt(thatMarker);
            }
            boolean thisChunkType = AlphanumComparator.isIn(thisChunk.charAt(0), numbers);
            boolean thatChunkType = AlphanumComparator.isIn(thatChunk.charAt(0), numbers);
            int result = 0;
            if (thisChunkType && thatChunkType) {
                thisNumericChunk = Long.parseLong(thisChunk);
                if (thisNumericChunk < (thatNumericChunk = Long.parseLong(thatChunk))) {
                    result = -1;
                }
                if (thisNumericChunk > thatNumericChunk) {
                    result = 1;
                }
            } else {
                result = thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

