/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import net.jsdai.repo_edit.util.XmlExternalizableAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BooleanXmlExternalizer
implements XmlExternalizableAdapter {
    private static final String VERSION_ATTR = "version";
    private static final String TAG_NAME = "bool";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final int VERSION_ID = 1;
    private final boolean value;

    public static BooleanXmlExternalizer valueOf(Element elem) {
        return BooleanXmlExternalizer.valueOf(elem, null);
    }

    public static BooleanXmlExternalizer valueOf(Element elem, ClassLoader classLoader) {
        if (elem == null) {
            throw new NullPointerException();
        }
        if (!elem.getTagName().equals(TAG_NAME)) {
            throw new IllegalArgumentException();
        }
        String attribute = elem.getAttribute(VALUE_ATTRIBUTE);
        return new BooleanXmlExternalizer(Boolean.parseBoolean(attribute));
    }

    public BooleanXmlExternalizer(boolean value) {
        this.value = value;
    }

    public Boolean getAdaptedObject() {
        return this.value;
    }

    public Element externalize(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        Element rootElem = doc.createElement(TAG_NAME);
        rootElem.setAttribute(VERSION_ATTR, String.valueOf(1));
        rootElem.setAttribute(VALUE_ATTRIBUTE, String.valueOf(this.value));
        return rootElem;
    }
}

