/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import java.util.ArrayList;
import java.util.List;
import net.jsdai.repo_edit.util.IEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager<S, E> {
    private final List<IEventListener<S, E>> listeners = new ArrayList<IEventListener<S, E>>();

    public void addListener(IEventListener<S, E> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IEventListener<S, E> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void notifyListener(S source, E event) {
        for (IEventListener<S, E> listener : new ArrayList<IEventListener<S, E>>(this.listeners)) {
            listener.handleEvent(source, event);
        }
    }
}

