/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.repo_edit.util;

import net.jsdai.repo_edit.util.XmlExternalizableAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StringXmlExternalizer
implements XmlExternalizableAdapter {
    private static final String VERSION_ATTR = "version";
    private static final String TAG_NAME = "str";
    private static final int VERSION_ID = 1;
    private final String str;

    @Deprecated
    public static StringXmlExternalizer valueOf(Element elem) {
        return StringXmlExternalizer.valueOf(elem, null);
    }

    public static StringXmlExternalizer valueOf(Element elem, ClassLoader classLoader) {
        if (elem == null) {
            throw new NullPointerException();
        }
        if (!elem.getTagName().equals(TAG_NAME)) {
            throw new IllegalArgumentException();
        }
        String str = "";
        NodeList childNodes = elem.getChildNodes();
        int i = 0;
        int n = childNodes.getLength();
        while (i < n) {
            Node child = childNodes.item(i);
            if (child instanceof Text) {
                str = ((Text)child).getData();
            }
            ++i;
        }
        return new StringXmlExternalizer(str);
    }

    public StringXmlExternalizer(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.str = str.replace("\u0000", "");
    }

    public String getAdaptedObject() {
        return this.getString();
    }

    public String getString() {
        return this.str;
    }

    public Element externalize(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        Element rootElem = doc.createElement(TAG_NAME);
        rootElem.setAttribute(VERSION_ATTR, String.valueOf(1));
        rootElem.appendChild(doc.createTextNode(this.str));
        return rootElem;
    }

    public boolean equals(Object anObject) {
        return this.str.equals(anObject);
    }

    public int hashCode() {
        return this.str.hashCode();
    }
}

