/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.ApplicationActionBarAdvisor;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.part.IOpenAction2;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;

public class ControlPipe {
    private static final ControlPipe instance = new ControlPipe();
    private ControlPipeJob job;

    private ControlPipe() {
    }

    public static ControlPipe getInstance() {
        return instance;
    }

    public void start() {
        if (this.job != null) {
            return;
        }
        this.job = new ControlPipeJob();
        this.job.schedule();
    }

    public void stop() {
        if (this.job == null) {
            return;
        }
        this.job.cancel();
        Thread thread = this.job.getThread();
        if (thread != null) {
            thread.interrupt();
        }
        this.job = null;
    }

    public boolean processAppArgs(IWorkbenchWindow window) throws PartInitException {
        String[] args = Platform.getApplicationArgs();
        boolean fileOpened = false;
        ActionFactory.IWorkbenchAction openWorkbenchAction = ApplicationActionBarAdvisor.getWeightedAction(window, "net.jsdai.product.openAction");
        IOpenAction2 openAction = null;
        if (openWorkbenchAction instanceof IOpenAction2) {
            openAction = (IOpenAction2)openWorkbenchAction;
        }
        if (openAction != null) {
            boolean fileNames = true;
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.startsWith("-")) {
                    fileNames = arg.startsWith("-f");
                } else if (fileNames) {
                    Path path = new Path(arg);
                    openAction.open((IPath)path);
                    fileOpened = true;
                }
                ++i;
            }
        }
        return fileOpened;
    }

    public boolean sendCommandsFromAppArgs() throws IOException {
        String[] args = Platform.getApplicationArgs();
        boolean fileNames = true;
        boolean sentCommand = false;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                fileNames = arg.startsWith("-f");
            } else if (fileNames) {
                File file = new File(arg);
                this.sendOpenFileCommand(file);
                sentCommand = true;
            }
            ++i;
        }
        return sentCommand;
    }

    public void sendOpenFileCommand(File file) throws IOException {
        this.sendCommand(String.valueOf('o') + file.getAbsolutePath());
    }

    public void sendOpenWindowCommand() throws IOException {
        this.sendCommand("w");
    }

    static void processCommand(String cmd) throws WorkbenchException {
        if (cmd.startsWith("o")) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            window.getShell().forceActive();
            window.getShell().forceFocus();
            ActionFactory.IWorkbenchAction openWorkbenchAction = ApplicationActionBarAdvisor.getWeightedAction(window, "net.jsdai.product.openAction");
            IOpenAction2 openAction = null;
            if (openWorkbenchAction instanceof IOpenAction2) {
                openAction = (IOpenAction2)openWorkbenchAction;
            }
            if (openAction != null) {
                Path path = new Path(cmd.substring(1));
                openAction.open((IPath)path);
            }
        } else if (cmd.startsWith("w")) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().openWorkbenchWindow(null);
            window.getShell().forceActive();
            window.getShell().forceFocus();
        }
    }

    private void sendCommand(String cmd) throws IOException {
        File stateDir = Activator.getDefault().getStateLocation().toFile();
        RandomAccessFile pipeFile = new RandomAccessFile(new File(stateDir, ".pipe"), "rws");
        try {
            FileLock pipeFileLock = pipeFile.getChannel().lock();
            try {
                pipeFile.seek(pipeFile.length());
                pipeFile.writeUTF(cmd);
            }
            finally {
                pipeFileLock.release();
            }
        }
        finally {
            pipeFile.close();
        }
    }

    private static class ControlPipeJob
    extends Job {
        ControlPipeJob() {
            super("ControlPipeJob");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(IdaStepMessages.ControlPipe_monitorTitle, -1);
            try {
                File stateDir = Activator.getDefault().getStateLocation().toFile();
                RandomAccessFile pipeFile = new RandomAccessFile(new File(stateDir, ".pipe"), "rws");
                try {
                    while (true) {
                        try {
                            pipeFile.seek(0L);
                            String cmd = pipeFile.readUTF();
                            FileLock pipeFileLock = pipeFile.getChannel().lock();
                            try {
                                while (true) {
                                    final String runCmd = cmd;
                                    Display.getDefault().syncExec(new Runnable(){

                                        public void run() {
                                            try {
                                                ControlPipe.processCommand(runCmd);
                                            }
                                            catch (WorkbenchException e) {
                                                Activator.getDefault().getLog().log((IStatus)new Status(4, "net.jsdai.ida_step", 0, "ControlPipeJob failed", (Throwable)e));
                                            }
                                        }
                                    });
                                    cmd = pipeFile.readUTF();
                                }
                            }
                            catch (Throwable throwable) {
                                pipeFile.setLength(0L);
                                pipeFileLock.release();
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            Thread.sleep(1000L);
                            if (!Thread.interrupted()) continue;
                            IStatus iStatus = Status.CANCEL_STATUS;
                            pipeFile.close();
                            return iStatus;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        pipeFile.close();
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

