/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PreferenceStateValidator {
    private static final String PROP_PERSPECTIVES = "perspectives";
    private static final IMementoRunnable validatePage = new IMementoRunnable(){

        public boolean run(IMemento page) {
            if (!PreferenceStateValidator.run(page, Arrays.asList("views", "view"), validateView)) {
                return false;
            }
            return PreferenceStateValidator.run(page, Arrays.asList(PreferenceStateValidator.PROP_PERSPECTIVES, "perspective"), validatePerspective);
        }
    };
    private static final IMementoRunnable validatePerspective = new IMementoRunnable(){

        public boolean run(IMemento perspective) {
            IMemento[] showViewActions;
            IMemento[] iMementoArray = showViewActions = perspective.getChildren("show_view_action");
            int n = showViewActions.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento showViewAction = iMementoArray[n2];
                String viewId = showViewAction.getString("id");
                if (!PreferenceStateValidator.isViewAvailable(viewId)) {
                    return false;
                }
                ++n2;
            }
            return PreferenceStateValidator.run(perspective, Arrays.asList("layout", "mainWindow", "info", "folder", "page"), new IMementoRunnable(){

                public boolean run(IMemento page) {
                    String viewId = page.getString("content");
                    return PreferenceStateValidator.isViewAvailable(viewId);
                }
            });
        }
    };
    private static final IMementoRunnable validateView = new IMementoRunnable(){

        public boolean run(IMemento view) {
            String viewId = view.getString("id");
            return PreferenceStateValidator.isViewAvailable(viewId);
        }
    };

    private PreferenceStateValidator() {
    }

    public static void validateWorkbenchUiSettings() {
        block11: {
            Bundle runtimeBundle = Platform.getBundle((String)"org.eclipse.core.runtime");
            if (runtimeBundle == null) {
                return;
            }
            IPath stateLocation = Platform.getStateLocation((Bundle)runtimeBundle);
            if (stateLocation == null) {
                return;
            }
            File stateDir = stateLocation.toFile();
            File settingsFile = new File(new File(stateDir, ".settings"), "org.eclipse.ui.workbench.prefs");
            if (!settingsFile.exists()) {
                return;
            }
            Properties settings = new Properties();
            try {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(settingsFile));
                settings.load(input);
                ((InputStream)input).close();
                String perspectives = settings.getProperty(PROP_PERSPECTIVES);
                if (perspectives == null) break block11;
                StringBuilder newPerspectives = new StringBuilder();
                Scanner scanner = new Scanner(perspectives);
                while (scanner.hasNext()) {
                    String perspectiveId = scanner.next();
                    String perspectiveKey = String.valueOf(perspectiveId) + "_persp";
                    String perspectiveDesc = settings.getProperty(perspectiveKey);
                    if (perspectiveDesc == null) continue;
                    boolean isValid = false;
                    try {
                        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(perspectiveDesc));
                        isValid = PreferenceStateValidator.run((IMemento)memento, Arrays.asList("view"), validateView);
                    }
                    catch (WorkbenchException e) {
                        Activator.logError("", e);
                    }
                    if (isValid) {
                        if (newPerspectives.length() > 0) {
                            newPerspectives.append(' ');
                        }
                        newPerspectives.append(perspectiveId);
                        continue;
                    }
                    settings.remove(perspectiveKey);
                }
                settings.setProperty(PROP_PERSPECTIVES, newPerspectives.toString());
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(settingsFile));
                settings.store(output, IdaStepMessages.PreferenceStateValidator_modifiedByIDA_STEP);
                ((OutputStream)output).close();
            }
            catch (FileNotFoundException e) {
                Activator.logError("", e);
            }
            catch (IOException e) {
                Activator.logError("", e);
            }
        }
    }

    public static void validateStateFile() {
        try {
            IPath stateLocation;
            File stateDir;
            File stateFile;
            Bundle workbenchUiBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
            if (workbenchUiBundle != null && (stateFile = new File(stateDir = (stateLocation = Platform.getStateLocation((Bundle)workbenchUiBundle)).toFile(), "workbench.xml")).exists()) {
                FileInputStream input = new FileInputStream(stateFile);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "utf-8"));
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                boolean isValid = PreferenceStateValidator.run((IMemento)memento, Arrays.asList("window", "page"), validatePage);
                reader.close();
                if (!isValid) {
                    stateFile.delete();
                }
            }
        }
        catch (FileNotFoundException e) {
            Activator.logError("", e);
        }
        catch (UnsupportedEncodingException e) {
            Activator.logError("", e);
        }
        catch (WorkbenchException e) {
            Activator.logError("", e);
        }
        catch (IOException e) {
            Activator.logError("", e);
        }
    }

    private static boolean run(IMemento parent, List<String> mementoPath, IMementoRunnable runnable) {
        block6: {
            IMemento[] children;
            int n;
            block5: {
                n = mementoPath.size();
                if (n == 0) {
                    return true;
                }
                children = parent.getChildren(mementoPath.get(0));
                if (n != 1) break block5;
                IMemento[] iMementoArray = children;
                int n2 = children.length;
                int n3 = 0;
                while (n3 < n2) {
                    IMemento child = iMementoArray[n3];
                    if (!runnable.run(child)) {
                        return false;
                    }
                    ++n3;
                }
                break block6;
            }
            if (n <= 1) break block6;
            List<String> tail = Collections.unmodifiableList(mementoPath.subList(1, n));
            IMemento[] iMementoArray = children;
            int n4 = children.length;
            int n5 = 0;
            while (n5 < n4) {
                IMemento child = iMementoArray[n5];
                if (!PreferenceStateValidator.run(child, tail, runnable)) {
                    return false;
                }
                ++n5;
            }
        }
        return true;
    }

    private static boolean isViewAvailable(String compoundId) {
        if (compoundId == null) {
            return true;
        }
        String[] compoundIdParts = compoundId.split(":");
        if (compoundIdParts.length > 0) {
            return PlatformUI.getWorkbench().getViewRegistry().find(compoundIdParts[0]) != null;
        }
        return false;
    }

    private static interface IMementoRunnable {
        public boolean run(IMemento var1);
    }
}

