/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.actions;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.util.Pair;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShopToolbarContributionItem
extends ContributionItem {
    private static final String PNG_EXTENSION = ".png";
    private static final Set<URL> processedAdvertismentButtonIcons = new HashSet<URL>();
    private static final String PREFERENCE_SEPARATOR = ";separator;";

    public static boolean openShop(Shell shell) {
        String genericUrl = null;
        String url = null;
        try {
            LicenseProperties licenseProperties = LicenseProperties.load();
            genericUrl = licenseProperties.getAdvertiseGenericUrl();
            URL advertiseUrl = licenseProperties.getAdvertiseUrl();
            if (advertiseUrl != null) {
                url = advertiseUrl.toString();
            }
        }
        catch (Exception e) {
            Activator.logError(" Failed to get license Properties", e);
        }
        boolean success = false;
        if (url != null) {
            if (Platform.getOS().equals("linux")) {
                success = Program.launch((String)("xdg-open " + url));
            }
            if (!success) {
                success = Program.launch((String)url);
            }
        }
        if (!success) {
            String msg = String.format(IdaStepMessages.ShopToolbarContributionItem_msgDialog_message, genericUrl);
            Activator.logError(msg, null);
            MessageDialog.openInformation((Shell)shell, (String)CommonStringsMessages.error, (String)msg);
            return false;
        }
        return true;
    }

    public ShopToolbarContributionItem() {
    }

    public ShopToolbarContributionItem(String id) {
        super(id);
    }

    public void fill(final ToolBar parent, int index) {
        LicenseProperties licenseProperties;
        try {
            licenseProperties = LicenseProperties.load();
            if (!licenseProperties.isAdvertiseShop()) {
                parent.setVisible(false);
                return;
            }
        }
        catch (Exception e) {
            Activator.logError("", e);
            return;
        }
        ToolItem showShopItem = new ToolItem(parent, 8, index);
        showShopItem.setToolTipText(licenseProperties.getAdvertiseGenericUrl());
        ImageDescriptor imageDescriptor = ShopToolbarContributionItem.getAdvertiseButtonIcon(licenseProperties);
        final Image image = imageDescriptor.createImage((Device)parent.getDisplay());
        showShopItem.setImage(image);
        showShopItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShopToolbarContributionItem.openShop(parent.getShell());
            }
        });
        showShopItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                image.dispose();
            }
        });
    }

    private static ImageDescriptor getAdvertiseButtonIcon(LicenseProperties licenseProperties) {
        URL advertiseButtonIconUrl = licenseProperties.getAdvertiseButtonIconUrl();
        if (advertiseButtonIconUrl != null) {
            Pair<Long, String> cache = ShopToolbarContributionItem.getAdvertiseButton(advertiseButtonIconUrl);
            if (cache != null) {
                File cachedFile = new File(Activator.getDefault().getStateLocation().toFile(), (String)cache.getSecond());
                try {
                    return ImageDescriptor.createFromURL((URL)cachedFile.toURL());
                }
                catch (Exception e) {
                    Activator.logError(NLS.bind((String)"Failed to read cached advertise button icon from {0} for button from URL {1}", (Object)cachedFile.getAbsolutePath(), (Object)advertiseButtonIconUrl.toString()), null);
                }
            }
        } else {
            Activator.logError("Failed to obtain advertise button URL from the license.", null);
        }
        return Activator.imageDescriptorFromPlugin((String)"net.jsdai.ida_step", (String)"icons/eshop.png");
    }

    private static Pair<Long, String> getAdvertiseButton(URL buttonUrl) {
        Pair<Long, String> cache = ShopToolbarContributionItem.getAdvertiseButtonCacheInfo(buttonUrl);
        if (processedAdvertismentButtonIcons.contains(buttonUrl)) {
            return cache;
        }
        processedAdvertismentButtonIcons.add(buttonUrl);
        try {
            URLConnection connection = buttonUrl.openConnection();
            if (connection instanceof HttpsURLConnection) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, null);
                httpsConnection.setSSLSocketFactory(sc.getSocketFactory());
            }
            long lastModified = connection.getLastModified();
            if (cache != null && (Long)cache.getFirst() == lastModified) {
                return cache;
            }
            try {
                String newFileName;
                Image image = new Image((Device)PlatformUI.getWorkbench().getDisplay(), connection.getInputStream());
                File cacheRootDir = Activator.getDefault().getStateLocation().toFile();
                if (cache != null) {
                    newFileName = (String)cache.getSecond();
                } else {
                    FilenameFilter pngFilter = new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(ShopToolbarContributionItem.PNG_EXTENSION);
                        }
                    };
                    newFileName = String.valueOf(String.valueOf(cacheRootDir.list(pngFilter).length + 1)) + PNG_EXTENSION;
                }
                File newFile = new File(cacheRootDir, newFileName);
                try {
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{image.getImageData()};
                    loader.save(newFile.getAbsolutePath(), 5);
                    Pair newCache = Pair.create((Object)lastModified, (Object)newFileName);
                    ShopToolbarContributionItem.storeAdvertiseButtonCacheInfo(buttonUrl, (Pair<Long, String>)newCache);
                    return newCache;
                }
                catch (SWTException e) {
                    Activator.logError(NLS.bind((String)"Failed to write advertise button from {0} to {1}", (Object)buttonUrl.toString(), (Object)newFile.getAbsolutePath()), e);
                }
            }
            catch (SWTException e) {
                Activator.logError(NLS.bind((String)"Failed to read advertise button from {0}", (Object)buttonUrl.toString()), e);
            }
        }
        catch (Exception e) {
            Activator.logError(NLS.bind((String)"Exception while trying to retrieve advertise button icon from {0}", (Object)buttonUrl.toString()), e);
        }
        return null;
    }

    private static Pair<Long, String> getAdvertiseButtonCacheInfo(URL buttonUrl) {
        String buttonUrlCacheInfo = Activator.getDefault().getPreferenceStore().getString(buttonUrl.toString());
        if (buttonUrlCacheInfo.length() == 0) {
            return null;
        }
        String[] split = buttonUrlCacheInfo.split(PREFERENCE_SEPARATOR);
        return Pair.create((Object)Long.parseLong(split[0]), (Object)split[1]);
    }

    private static void storeAdvertiseButtonCacheInfo(URL buttonUrl, Pair<Long, String> cache) {
        String preferenceValue = cache.getFirst() + PREFERENCE_SEPARATOR + (String)cache.getSecond();
        Activator.getDefault().getPreferenceStore().setValue(buttonUrl.toString(), preferenceValue);
    }
}

