/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jsdai.ida_step.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class HtmlMessageDialog
extends Dialog {
    private static final Pattern CONT_TYPE_ELEM_DELIM_PATTERN = Pattern.compile(";");
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.+)", 2);
    private final String messageHtml;
    private final String title;

    private HtmlMessageDialog(Shell parentShell, String title, String messageHtml) {
        super(parentShell);
        this.title = title;
        this.messageHtml = messageHtml;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public static void open(Shell parentShell, String title, String content, int fallbackDialogType) {
        try {
            HtmlMessageDialog dialog = new HtmlMessageDialog(parentShell, title, content);
            dialog.open();
        }
        catch (Throwable e) {
            Activator.logError("", e);
            MessageDialog.open((int)fallbackDialogType, (Shell)parentShell, (String)title, (String)content, (int)0);
        }
    }

    private static String getCharset(String contType) {
        String[] contTypeElements = CONT_TYPE_ELEM_DELIM_PATTERN.split(contType);
        String charset = "UTF-8";
        if (contTypeElements.length > 1) {
            Matcher charsetMatcher = CHARSET_PATTERN.matcher("");
            int i = 1;
            while (i < contTypeElements.length) {
                charsetMatcher.reset(contTypeElements[i].trim());
                if (charsetMatcher.matches()) {
                    charset = charsetMatcher.group(1);
                    break;
                }
                ++i;
            }
        }
        try {
            Charset.forName(charset);
        }
        catch (Exception e) {
            Activator.logError("", e);
            charset = Charset.defaultCharset().name();
        }
        return charset;
    }

    public static String httpStreamToString(InputStream stream, String contentType) throws IOException {
        String charset = HtmlMessageDialog.getCharset(contentType);
        InputStreamReader streamReader = new InputStreamReader(stream, charset);
        StringBuilder messageBuf = new StringBuilder();
        try {
            char[] buffer = new char[1024];
            int count = 0;
            while ((count = ((Reader)streamReader).read(buffer, 0, buffer.length)) != -1) {
                messageBuf.append(buffer, 0, count);
            }
        }
        finally {
            ((Reader)streamReader).close();
        }
        return messageBuf.toString();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        final Text header = new Text(dialogArea, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        header.setLayoutData((Object)gridData);
        header.setBackground(dialogArea.getBackground());
        this.initializeDialogUnits((Control)header);
        Browser messageBrowser = new Browser(dialogArea, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        messageBrowser.setLayoutData((Object)gridData);
        messageBrowser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if (!"about:blank".equals(event.title)) {
                    header.setText(event.title);
                    header.pack();
                }
            }
        });
        messageBrowser.setText(this.messageHtml);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setFocus();
    }

    protected Point getInitialSize() {
        return new Point(this.convertHorizontalDLUsToPixels(300), this.convertVerticalDLUsToPixels(150));
    }
}

