/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.net.HttpURLConnection;
import net.jsdai.ida_step.Activator;
import net.jsdai.ida_step.installation.HtmlMessageDialog;
import net.jsdai.ida_step.installation.HttpUtil;
import net.jsdai.ida_step.installation.LicenseProperties;
import net.jsdai.ida_step.l10n.CommonStringsMessages;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchWindow;

public class NewsJob
extends Job {
    private final IWorkbenchWindow window;

    public NewsJob(String name, IWorkbenchWindow window) {
        super(name);
        this.window = window;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(IdaStepMessages.NewsJob_monitorTask_gettingNews, -1);
            HttpUtil.configureConnection();
            HttpURLConnection newsConnection = HttpUtil.doRequest(LicenseProperties.load().getLicenseNumber(), "news/", monitor);
            int respCode = newsConnection.getResponseCode();
            if (respCode == 200) {
                String contentType = newsConnection.getContentType();
                final String content = HtmlMessageDialog.httpStreamToString(newsConnection.getInputStream(), contentType);
                if (content.contains("No news generated")) {
                    LicensingService.getInstance().deleteLicense();
                } else if (content.length() > 0) {
                    this.window.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            HtmlMessageDialog.open(NewsJob.this.window.getShell(), CommonStringsMessages.news, content, 2);
                        }
                    });
                }
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "net.jsdai.ida_step", 0, "NewsJob.run() HTTP connection failed with " + respCode, null));
            }
            monitor.done();
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        catch (Throwable e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "net.jsdai.ida_step", 0, "NewsJob.run() failed", e));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

