/*
 * Decompiled with CFR 0.152.
 */
package net.jsdai.ida_step.installation;

import java.io.IOException;
import net.jsdai.ida_step.l10n.IdaStepMessages;
import net.jsdai.repo_edit.services.LicensingService;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RegistrationMethodPage
extends WizardPage {
    private static final String REGISTRATION_PAGE_CONTEXT_ID = "net.jsdai.ida_step.registration_page_context_2_page";
    private Button onlineReg;
    private Button offlineReg;

    public RegistrationMethodPage() {
        super("registrationMethodPage");
        this.setTitle(IdaStepMessages.RegistrationMethodPage_title);
        this.setDescription(IdaStepMessages.RegistrationMethodPage_description);
    }

    public void createControl(Composite parent) {
        try {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            this.createRegistrationMethodGroup(composite);
            this.setControl((Control)composite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createRegistrationMethodGroup(Composite composite) throws IOException {
        boolean offline2ndStepRegEnabled = LicensingService.getInstance().loadOfflineLicense() != null;
        Composite regMethodComposite = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        regMethodComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        regMethodComposite.setLayout((Layout)layout);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    RegistrationMethodPage.this.getContainer().updateButtons();
                }
            }
        };
        this.onlineReg = new Button(regMethodComposite, 16);
        this.onlineReg.setText(IdaStepMessages.RegistrationMethodPage_onlineReg_text);
        gridData = new GridData();
        this.onlineReg.setLayoutData((Object)gridData);
        if (!offline2ndStepRegEnabled) {
            this.onlineReg.setSelection(true);
        }
        this.onlineReg.addSelectionListener((SelectionListener)buttonListener);
        Button tempButton = new Button(regMethodComposite, 16);
        int indent = tempButton.computeSize((int)-1, (int)-1).x;
        tempButton.dispose();
        int prefControlWidth = this.getPrefControlWidth();
        int labelWidth = prefControlWidth - indent - 20;
        Label onlineRegLabel = new Label(regMethodComposite, 64);
        onlineRegLabel.setText(IdaStepMessages.RegistrationMethodPage_onlineRegLabel_text);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        gridData.horizontalIndent = indent;
        onlineRegLabel.setLayoutData((Object)gridData);
        this.offlineReg = new Button(regMethodComposite, 16);
        this.offlineReg.setText(IdaStepMessages.RegistrationMethodPage_offlineReg_text);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.offlineReg.setLayoutData((Object)gridData);
        if (offline2ndStepRegEnabled) {
            this.offlineReg.setSelection(true);
        }
        this.offlineReg.addSelectionListener((SelectionListener)buttonListener);
        Label offlineGroupLabel = new Label(regMethodComposite, 64);
        offlineGroupLabel.setText(IdaStepMessages.RegistrationMethodPage_offlineGroupLabel_text);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = labelWidth;
        gridData.horizontalIndent = indent;
        offlineGroupLabel.setLayoutData((Object)gridData);
        gridData = (GridData)regMethodComposite.getLayoutData();
        gridData.heightHint = regMethodComposite.computeSize((int)prefControlWidth, (int)-1).y;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, REGISTRATION_PAGE_CONTEXT_ID);
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.isOfflineMethod();
    }

    boolean isOfflineMethod() {
        return this.offlineReg.getSelection();
    }

    private int getPrefControlWidth() {
        Control registrationPageControl;
        IWizardPage registrationPage = this.getWizard().getPage("registrationPage");
        if (registrationPage != null && (registrationPageControl = registrationPage.getControl()) != null) {
            return registrationPageControl.computeSize((int)-1, (int)-1).x;
        }
        return this.convertHorizontalDLUsToPixels(275);
    }
}

