/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.parts;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.ImageOverlayIcon;
import org.eclipse.update.internal.ui.parts.OverlayIcon;

public class SharedLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int F_ERROR = 1;
    public static final int F_WARNING = 2;
    public static final int F_CURRENT = 4;
    public static final int F_INSTALLABLE = 8;
    public static final int F_LINKED = 16;
    public static final int F_MOD = 32;
    public static final int F_UPDATED = 64;
    public static final int F_UNCONFIGURED = 128;
    public static final int F_ADD = 256;
    public static final int F_DEL = 512;
    Hashtable images = new Hashtable();
    ArrayList consumers = new ArrayList();

    public void connect(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void disconnect(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.size() == 0) {
            this.reset();
        }
    }

    public void dispose() {
        this.reset();
        super.dispose();
    }

    private void reset() {
        Enumeration iterator = this.images.elements();
        while (iterator.hasMoreElements()) {
            Image image = (Image)iterator.nextElement();
            image.dispose();
        }
        this.images.clear();
    }

    public Image get(ImageDescriptor desc) {
        return this.get(desc, 0);
    }

    public Image get(ImageDescriptor desc, int flags) {
        Image image;
        Object key = desc;
        if (flags != 0) {
            key = this.getKey(desc.hashCode(), flags);
        }
        if ((image = (Image)this.images.get(key)) == null) {
            image = this.createImage(desc, flags);
            this.images.put(key, image);
        }
        return image;
    }

    public Image get(Image image, int flags) {
        if (flags == 0) {
            return image;
        }
        String key = this.getKey(image.hashCode(), flags);
        Image resultImage = (Image)this.images.get(key);
        if (resultImage == null) {
            resultImage = this.createImage(image, flags);
            this.images.put(key, resultImage);
        }
        return resultImage;
    }

    private String getKey(long hashCode, int flags) {
        return hashCode + ":" + flags;
    }

    private Image createImage(ImageDescriptor baseDesc, int flags) {
        if (flags == 0) {
            return baseDesc.createImage();
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        OverlayIcon compDesc = new OverlayIcon(baseDesc, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    private Image createImage(Image baseImage, int flags) {
        if (flags == 0) {
            return baseImage;
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        ImageOverlayIcon compDesc = new ImageOverlayIcon(baseImage, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    private ImageDescriptor[] getLowerLeftOverlays(int flags) {
        if ((flags & 1) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_ERROR_CO};
        }
        if ((flags & 2) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_WARNING_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperRightOverlays(int flags) {
        if ((flags & 0x100) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_ADD_CO};
        }
        if ((flags & 0x200) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_DEL_CO};
        }
        if ((flags & 0x80) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_UNCONF_CO};
        }
        if ((flags & 0x10) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_LINKED_CO};
        }
        return null;
    }

    private ImageDescriptor[] getLowerRightOverlays(int flags) {
        if ((flags & 4) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_CURRENT_CO};
        }
        if ((flags & 0x20) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_MOD_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperLeftOverlays(int flags) {
        if ((flags & 0x40) != 0) {
            return new ImageDescriptor[]{UpdateUIImages.DESC_UPDATED_CO};
        }
        return null;
    }

    public String getColumnText(Object obj, int index) {
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return this.getImage(obj);
    }

    public Image getImageFromURL(URL installURL, String subdirectoryAndFilename) {
        Image image = null;
        try {
            URL newURL = new URL(installURL, subdirectoryAndFilename);
            String key = newURL.toString();
            image = (Image)this.images.get(key);
            if (image == null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)newURL);
                image = desc.createImage();
                this.images.put(key, image);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
        return image;
    }
}

