/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.SiteBookmark;

public class LocalSiteSelector {
    static String lastLocation = null;

    public static SiteBookmark getLocaLSite(Shell parent, SiteBookmark[] siteBookmarks) {
        DirectoryDialog dialog = new DirectoryDialog(parent);
        dialog.setMessage(UpdateUIMessages.LocalSiteSelector_dialogMessage);
        dialog.setFilterPath(lastLocation);
        String dir = dialog.open();
        SiteBookmark siteBookmark = null;
        while (dir != null && siteBookmark == null) {
            File dirFile = new File(dir);
            if (LocalSiteSelector.isDirSite(dirFile)) {
                if (!LocalSiteSelector.isDuplicate(dirFile, siteBookmarks)) {
                    siteBookmark = LocalSiteSelector.createDirSite(dirFile);
                    lastLocation = dir;
                    continue;
                }
                MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_dirInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_dirDuplicateDefinition);
                dialog.setFilterPath(dir);
                dir = dialog.open();
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_dirInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_dirInfoMessage);
            dialog.setFilterPath(dir);
            dir = dialog.open();
        }
        return siteBookmark;
    }

    public static SiteBookmark getLocaLZippedSite(Shell parent, SiteBookmark[] siteBookmarks) {
        FileDialog dialog = new FileDialog(parent);
        dialog.setText(UpdateUIMessages.LocalSiteSelector_dialogMessagezip);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        SiteBookmark siteBookmark = null;
        String zip = dialog.open();
        while (zip != null && siteBookmark == null) {
            File zipF = new File(zip);
            if (LocalSiteSelector.isZipSite(zipF)) {
                siteBookmark = LocalSiteSelector.createZipSite(zipF);
                if (!LocalSiteSelector.isDuplicate(siteBookmark.getURL(), siteBookmarks)) continue;
                MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_zipInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_zipDuplicateDefinition);
                siteBookmark = null;
                zip = dialog.open();
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUIMessages.LocalSiteSelector_zipInfoTitle, (String)UpdateUIMessages.LocalSiteSelector_zipInfoMessage);
            zip = dialog.open();
        }
        return siteBookmark;
    }

    static boolean isZipSite(File file) {
        if (!file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".jar")) {
            return false;
        }
        ZippedSiteValidator validator = new ZippedSiteValidator(file);
        BusyIndicator.showWhile((Display)UpdateUI.getActiveWorkbenchShell().getDisplay(), (Runnable)validator);
        return validator.isValid();
    }

    static boolean isDirSite(File dir) {
        File siteXML = new File(dir, "site.xml");
        File featuresDir = new File(dir, "features");
        File pluginsDir = new File(dir, "plugins");
        return siteXML.exists() || featuresDir.exists() && featuresDir.isDirectory() && pluginsDir.exists() && pluginsDir.isDirectory();
    }

    static SiteBookmark createZipSite(File file) {
        try {
            URL fileURL = new URL("file", null, file.getAbsolutePath());
            URL url = new URL("jar:" + fileURL.toExternalForm().replace('\\', '/') + "!/");
            SiteBookmark site = new SiteBookmark(file.getName(), url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception e) {
            return null;
        }
    }

    static SiteBookmark createDirSite(File file) {
        try {
            URL url = file.toURL();
            String parent = file.getParent();
            parent = parent == null ? "" : new File(parent).getName();
            String siteName = String.valueOf(parent) + "/" + file.getName();
            SiteBookmark site = new SiteBookmark(siteName, url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isDuplicate(File file, SiteBookmark[] siteBookmarks) {
        try {
            return LocalSiteSelector.isDuplicate(file.toURL(), siteBookmarks);
        }
        catch (MalformedURLException mue) {
            UpdateUI.logException(mue);
            return false;
        }
    }

    private static boolean isDuplicate(URL url, SiteBookmark[] siteBookmarks) {
        if (siteBookmarks == null) {
            return false;
        }
        int i = 0;
        while (i < siteBookmarks.length) {
            if (siteBookmarks[i].getURL().equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class ZippedSiteValidator
    implements Runnable {
        File file;
        boolean valid = false;

        public ZippedSiteValidator(File file) {
            this.file = file;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

